﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub NI PXI-4130 (1 yr) 6 V Prog Acc Ch0 Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) 6 V Prog Acc Ch1 Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) 20 V Prog Acc Ch1 Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) 6 V Meas Acc Ch0 Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) 20 V Meas Acc Ch1 Test LIB /8508
DATE:                  2011-12-08 13:39:01
AUTHOR:                Fluke
REVISION:              $Revision: 1.2 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       11
NUMBER OF LINES:       206
CONFIGURATION:         Fluke 8508A
=============================================================================
#
#  Text Source:
#    $RCSfile: sub_ni_pxi-4130_1yr_voltage_test_lib_8508.txt,v $
#    $Date: 2011/10/24 19:04:32 $
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        PXI-4130
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Subprocedures:
#        Sub NI DC Power Setup LIB
#        Sub NI DC Power Output Off LIB
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         VOLT_PROG_ACC_CH0_6V_RANGE   PSUBI("6 V Prog Acc Ch0")
  1.002  JMPL         VOLT_PROG_ACC_CH1_6V_RANGE   PSUBI("6 V Prog Acc Ch1")
  1.003  JMPL         VOLT_PROG_ACC_CH1_20V_RANGE  PSUBI("20 V Prog Acc Ch1")
  1.004  JMPL         VOLT_MEAS_ACC_CH0_6V_RANGE   PSUBI("6 V Meas Acc Ch0")
  1.005  JMPL         VOLT_MEAS_ACC_CH1_20V_RANGE  PSUBI("20 V Meas Acc Ch1")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) 6 V Prog Acc Ch0 Test LIB /8508  ============

  2.001  LABEL        VOLT_PROG_ACC_CH0_6V_RANGE
  2.002  JMPL         START_VOLT_PROG_ACC_CH0_6V_RANGE

  2.003  TARGET       -p
  2.004  MATH         @First = 1

  2.005  LABEL        START_VOLT_PROG_ACC_CH0_6V_RANGE

  2.006  IF           @First
  2.007  DISP         Connect the UUT to the 8508A as follows:
  2.007  DISP
  2.007  DISP         [32]       UUT           8508A
  2.007  DISP         [32] Channel 0 High ---> INPUT HI
  2.007  DISP         [32] Channel 0 Low ----> INPUT LO
  2.008  MATH         @First = 0
  2.009  ENDIF

  2.010  CALL         Sub NI DC Power Setup LIB
  2.011  WAIT         -t 10 Settling...
  2.012  TARGET       -m
  2.013  MATH         MEM = @niDCPwrVolt
  2.014  8508   6     V              0.05% 0.0040U                         2W

  3.001  END

  3.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) 6 V Prog Acc Ch1 Test LIB /8508  ============

  4.001  LABEL        VOLT_PROG_ACC_CH1_6V_RANGE
  4.002  JMPL         START_VOLT_PROG_ACC_CH1_6V_RANGE

  4.003  TARGET       -p
  4.004  MATH         @First = 1

  4.005  LABEL        START_VOLT_PROG_ACC_CH1_6V_RANGE

  4.006  IF           @First
  4.007  DISP         Connect the UUT to the 8508A as follows:
  4.007  DISP
  4.007  DISP         [32]       UUT           8508A
  4.007  DISP         [32] Channel 1 High ---> INPUT HI
  4.007  DISP         [32] Channel 1 Low ----> INPUT LO
  4.008  MATH         @First = 0
  4.009  ENDIF

  4.010  TSET         CPT = [V @niDCPwrVolt] V; MEAS = SA
  4.011  CALL         Sub NI DC Power Setup LIB
  4.012  WAIT         -t 3 Settling...
  4.013  TARGET       -m
  4.014  MATH         MEM = @niDCPwrVolt
  4.015  8508   6     V              .034% .0015U                          2W

  5.001  END

  5.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) 20 V Prog Acc Ch1 Test LIB /8508  ==========

  6.001  LABEL        VOLT_PROG_ACC_CH1_20V_RANGE
  6.002  TARGET       -p
  6.003  CALL         Sub NI DC Power Setup LIB
  6.004  WAIT         -t 3 Settling...
  6.005  TARGET       -m
  6.006  MATH         MEM = @niDCPwrVolt
  6.007  8508   20    V              .034% .0018U                          2W

  7.001  END

  7.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) 6 V Meas Acc Ch0 Test LIB /8508  ===========

  8.001  LABEL        VOLT_MEAS_ACC_CH0_6V_RANGE
  8.002  TARGET       -p
  8.003  TSET         CPT = [V @niDCPwrVolt] V
  8.004  MATH         @Method = "NI DC Power Abort"

  8.005  DO
  8.006  LIB          @Status = uut.niDCPower_Abort(@vi);

  8.007  IF           @Status
  8.008  CALL         Sub NI DC Power Error Message LIB
  8.009  ENDIF

  8.010  UNTIL        (@Status == 0)

  8.011  MATH         @Method = "NI DC Power Set Attribute"

  8.012  DO
  8.013  LIB          @Status = uut.niDCPower_SetAttributeViInt32
  8.013  LIB          (@vi, @niDCPwrChan, @niDCPwrAttrSamplesToAvg, 300);

  8.014  IF           @Status
  8.015  CALL         Sub NI DC Power Error Message LIB
  8.016  ENDIF

  8.017  UNTIL        (@Status == 0)

  8.018  CALL         Sub NI DC Power Setup LIB
  8.019  WAIT         -t 3 Settling...
  8.020  MATH         MEM = @niDCPwrVolt
  8.021  8508         V                                              D5 N  2W
  8.022  MATH         SystemActual = MEM
  8.023  MATH         @Method = "NI DC Power Measure"
  8.024  TARGET       -m

  8.025  DO
  8.026  LIB          @Status = uut.niDCPower_Measure
  8.026  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasVolt, MEM);

  8.027  IF           @Status
  8.028  CALL         Sub NI DC Power Error Message LIB
  8.029  ENDIF

  8.030  UNTIL        (@Status == 0)

  8.031  MATH         MEM1 = SystemActual
  8.032  MEMCX  6     V              0.05% 0.0040U

  9.001  END

  9.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) 20 V Meas Acc Ch1 Test LIB /8508  ==========

 10.001  LABEL        VOLT_MEAS_ACC_CH1_20V_RANGE
 10.002  TARGET       -p
 10.003  TSET         CPT = [V @niDCPwrVolt] V
 10.004  CALL         Sub NI DC Power Setup LIB
 10.005  WAIT         -t 3 Settling...
 10.006  MATH         MEM = @niDCPwrVolt
 10.007  8508         V                                              D5 N  2W
 10.008  MATH         SystemActual = MEM
 10.009  MATH         @Method = "NI DC Power Measure"
 10.010  TARGET       -m

 10.011  DO
 10.012  LIB          @Status = uut.niDCPower_Measure
 10.012  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasVolt, MEM);

 10.013  IF           @Status
 10.014  CALL         Sub NI DC Power Error Message LIB
 10.015  ENDIF

 10.016  UNTIL        (@Status == 0)

 10.017  MATH         MEM1 = SystemActual
 10.018  MEMCX  20    V              .034% .0018U

 11.001  END